/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.client.screen.QuestScreen;
import dev.toma.gunsrpg.common.entity.MayorEntity;
import dev.toma.gunsrpg.common.quests.mayor.ReputationStatus;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2C_OpenQuestScreen
extends AbstractNetworkPacket<S2C_OpenQuestScreen> {
    private ReputationStatus status;
    private MayorEntity.ListedQuests quests;
    private int entityId;
    private long timer;

    public S2C_OpenQuestScreen() {
    }

    public S2C_OpenQuestScreen(ReputationStatus status, MayorEntity.ListedQuests quests, int entityId, long timer) {
        this.status = status;
        this.quests = quests;
        this.entityId = entityId;
        this.timer = timer;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.status);
        CompoundNBT wrap = new CompoundNBT();
        wrap.func_218657_a("contents", (INBT)this.quests.toNbt());
        buffer.func_150786_a(wrap);
        buffer.writeInt(this.entityId);
        buffer.writeLong(this.timer);
    }

    @Override
    public S2C_OpenQuestScreen decode(PacketBuffer buffer) {
        ReputationStatus status = (ReputationStatus)buffer.func_179257_a(ReputationStatus.class);
        CompoundNBT wrap = buffer.func_150793_b();
        ListNBT content = wrap.func_150295_c("contents", 10);
        MayorEntity.ListedQuests quests = MayorEntity.ListedQuests.loadNbt(content);
        return new S2C_OpenQuestScreen(status, quests, buffer.readInt(), buffer.readLong());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        Entity entity = world.func_73045_a(this.entityId);
        if (!(entity instanceof MayorEntity)) {
            return;
        }
        mc.func_147108_a((Screen)new QuestScreen(this.status, this.quests.getQuests(), (MayorEntity)entity, this.timer));
    }
}

